<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('anggotas', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 36)->unique();  // Gunakan varchar(36) untuk UUID
            $table->string('nama');
            $table->string('no_kta')->nullable();  // Kolom no_kta yang nullable
            $table->string('no_wa');
            $table->string('nama_perusahaan');
            $table->string('alamat')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('anggotas');
    }
};
