<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class MuscabInvitationEmail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $anggota;
    public $qrCodeUrl;

    public function __construct($anggota, $qrCodeUrl = null)
    {
        $this->anggota = $anggota;
        $this->qrCodeUrl = $qrCodeUrl;
    }

    public function build()
    {
        return $this->subject('Muscab BPC HIPMI Karawang')
            ->markdown('emails.muscab_invitation');
    }
}
